/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tomcat;

import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tomcat.HmcPrincipal;
import com.ibm.hwmca.fw.util.Trace;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;

public class HmcRealm
extends RealmBase {
    private static final String TRACE_MASKT = "XTOMRLMT";
    private static final String TRACE_MASKF = "XTOMRLMF";
    private static final String TRACE_MASKD = "XTOMRLMD";
    private static final String realmName = "Hardware Management Console Realm";
    private static final String roleName = "Hardware Management Console Role";
    ArrayList roles = new ArrayList();
    private CommonSystem commonSystem = CommonSystem.getCommonSystem();

    public HmcRealm() {
        Trace.trace(TRACE_MASKF, "HmcRealm.ctor()");
        this.roles = new ArrayList();
        this.roles.add(roleName);
    }

    public String getName() {
        return realmName;
    }

    public String getPassword(String username) {
        Trace.trace(TRACE_MASKF, "getPassword for [" + username + "]; this should NEVER be called!");
        return null;
    }

    public Principal getPrincipal(String username) {
        Trace.trace(TRACE_MASKF, "getPrincipal for [" + username + "]");
        return new HmcPrincipal((Realm)this, username, this.roles, null);
    }

    public Principal authenticate(String username, byte[] encryptedPassword) {
        Trace.trace(TRACE_MASKF, "-> authenticate for [" + username + "]");
        HmcPrincipal p = null;
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory(this.commonSystem.getManagerHost(), 9940);
            connectionFactory.setUserAndPassword(username, encryptedPassword);
            p = new HmcPrincipal((Realm)this, username, this.roles, connectionFactory);
            if (username.toUpperCase().equals("PEDEBUG")) {
                FrameworkEventText fet = new FrameworkEventText(38, null);
                new SystemEventLog(fet, "PCLGNDBG").log();
                new E4EventLog(fet, "PCLGNDBG").log();
            }
        }
        catch (InvalidPasswordException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        catch (DisabledUseridException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        catch (UnknownHostException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<- authenticate");
        return p;
    }

    public Principal authenticate(String username, String password) {
        if (username == null || password == null) {
            return null;
        }
        return this.authenticate(username, this.commonSystem.hashPassword(password.toUpperCase()));
    }

    public void log(String msg) {
        Trace.trace(TRACE_MASKF, msg);
    }

    public void log(String msg, Throwable t) {
        Trace.trace(TRACE_MASKF, msg);
        Trace.trace(TRACE_MASKF, t);
    }

    public void start() {
        Trace.trace(TRACE_MASKF, "<>HmcRealm.start()");
    }
}

